#include <amxmodx>

#define PLUGIN "Rock the Ban"
#define VERSION "1.0"
#define AUTHOR "Sho0ter"

enum _players
{
	p_steamid[34],
	p_players[33],
	p_voted[33],
	p_name[32],
	p_ip[22],
	p_votecount,
	p_count,
	p_position,
	p_playersnum,
	p_admin
}

new player[33][_players]

enum _temp
{
	t_allvotes,
	t_yesvotes,
	t_showed,
	t_invote,
	t_id
}

new temp[_temp]

enum _server
{
	s_admins,
	s_saytext,
	s_maxplayers,
	s_start_percent,
	s_ban_percent,
	s_calculate,
	s_immunity,
	s_no_use,
	s_ban_command,
	s_ended
}

new server[_server]

public plugin_init()
{
	register_plugin_post(PLUGIN, VERSION, AUTHOR)
	
	register_dictionary("rock_the_ban.txt")
	
	register_menucmd(register_menuid("pl menu"), 1023, "plmenu")
	register_menucmd(register_menuid("vote menu"), 1023, "votemenu")
	
	register_clcmd("say", "cmd_say")
	register_clcmd("say_team", "cmd_say")
	
	server[s_start_percent] = register_cvar("rtb_start_percent", "0.33")
	server[s_ban_percent] = register_cvar("rtb_ban_percent", "0.66")
	server[s_calculate] = register_cvar("rtb_calculate_type", "1")
	server[s_immunity] = register_cvar("rtb_ban_immunuty", "a")
	server[s_no_use] = register_cvar("rtb_admin_nouse", "d")
	server[s_ban_command] = register_cvar("rtb_ban_command", "amx_ban %userid% 60 %reason%")

	server[s_saytext] = get_user_msgid("SayText")
	server[s_maxplayers] = get_maxplayers()
	
	return PLUGIN_CONTINUE
}

public plugin_cfg()
{
	new configsdir[128]
	get_localinfo("amxx_configsdir", configsdir, 127)
	
	return server_cmd("exec %s/rock_the_ban.cfg", configsdir)
}

public client_putinserver(id)
{
	for(new i; i < player[id][p_votecount]; i++)
	{
		player[id][p_voted][i] = 0
	}
	
	player[id][p_votecount] = 0
	
	new tempname[32]
	get_user_name(id, tempname, 31)
	
	new tempip[32]
	get_user_ip(id, tempip, 31, 1)
	
	if(!equal(tempip, player[id][p_ip]) && !equal(tempname, player[id][p_name]))
	{
		for(new i = 1; i <= server[s_maxplayers]; i++)
		{
			new tempid = get_voted_pos(i, id)
			
			if(tempid >= 0)
			{
				for(new n = tempid; n < player[id][p_votecount]; n++)
				{
					new m = player[i][p_voted][n + 1]
					player[i][p_voted][n] = m
				}
				
				player[i][p_votecount]--
			}
		}
		
		player[id][p_count] = 0
	}
	else
	{
		check_rocks(0)
	}
	
	new iflags = get_user_flags(id)
	
	new str[32]
	get_pcvar_string(server[s_no_use], str, 31)
	
	if(strlen(str) && (iflags & read_flags(str)))
	{
		server[s_admins]++
		player[id][p_admin] = 1
	}
	
	get_user_name(id, player[id][p_name], 31)
	get_user_authid(id, player[id][p_steamid], 33)
	get_user_ip(id, player[id][p_ip], 21, 1)
	
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	for(new i; i < player[id][p_votecount]; i++)
	{
		if(player[player[id][p_voted][i]][p_count])
		{
			player[player[id][p_voted][i]][p_count]--
		}
		
		player[i][p_voted][id] = 0
	}
	
	player[id][p_votecount] = 0
	
	if(player[id][p_admin])
	{
		server[s_admins]--
		player[id][p_admin] = 0
	}
	
	check_rocks(0)
	
	if(temp[t_id] == id) check_votes(666/* :P */)
	
	return PLUGIN_CONTINUE
}

public client_infochanged(id)
{
	get_user_info(id, "name", player[id][p_name], 31)
	
	return PLUGIN_CONTINUE
}

public cmd_say(id)
{
	new args[64]
	read_args(args, 63)
	remove_quotes(args)
	
	new arg1[32], arg2[32]
	strbreak(args, arg1, 31, arg2, 31)
	
	if(arg1[0] == '/') format(arg1, 31, arg1[1])
	
	if(equal(arg1, "voteban", 6) || equal(arg1, "rocktheban", 10) || equal(arg1, "rtb", 3))
	{
		if(server[s_admins])
		{
			color_print(id, "%L", id, "RTB_NOT_NOW")
			return PLUGIN_CONTINUE
		}
		
		if(strlen(arg2))
		{
			new pid = find_player("bl", arg2)
			
			new str[32]
			get_pcvar_string(server[s_immunity], str, 31)
			
			if(!pid || pid == id || !is_user_connected(pid) || (strlen(str) && get_user_flags(pid) & read_flags(str)) || player[pid][p_count] >= floatround(float(get_playersnum() - 1) * get_pcvar_float(server[s_start_percent]), floatround_ceil))
			{
				show_plmenu(id, player[id][p_position] = 0)
			}
			else if(get_voted_pos(id, pid) != -1)
			{
				color_print(id, "%L", id, "RTB_ALREADY_WOTED")
			}
			else
			{
				check_rocks(id, pid)
			}
		}
		else
		{
			show_plmenu(id, player[id][p_position] = 0)
		}
	}
	
	return PLUGIN_CONTINUE
}

stock check_rocks(id, pid = 0)
{
	if(server[s_ended] || (get_playersnum() - 1) < 1)
	{
		return PLUGIN_CONTINUE
	}
	
	if(id)
	{
		player[pid][p_count]++
					
		player[id][p_voted][player[id][p_votecount]++] = pid
	}
				
	new percent = floatround(float(get_playersnum() - 1) * get_pcvar_float(server[s_start_percent]), floatround_ceil)
	if(!percent) percent++
	
	if(id)
	{
		if(player[pid][p_count] >= percent && !temp[t_invote])
		{
			start_vote(pid)
		}
		else if(!temp[t_invote])
		{
			for(new i = 1; i <= server[s_maxplayers]; i++)
			{
				if(i == pid || !is_user_connected(i))
				{
					continue
				}
							
				color_print(i, "%L", i, "RTB_ROCKED", player[id][p_name], player[pid][p_name], percent - player[pid][p_count])
			}
		}
	}
	else
	{
		for(new i = 1; i <= server[s_maxplayers]; i++)
		{
			if(!is_user_connected(i))
			{
				continue
			}
			
			if(player[i][p_count] >= percent)
			{
				return start_vote(i)
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

public start_vote(id)
{
	new body[256], ishowed
						
	for(new i = 1; i <= server[s_maxplayers]; i++)
	{
		if(i == id || !is_user_connected(i))
		{
			continue
		}
							
		color_print(i, "%L", i, "RTB_VOTE_STARTED", floatround(get_pcvar_float(server[s_start_percent]) * 100.0), player[id][p_name])
							
		formatex(body, 1023, "\y%L \r%s^n^n\r1. \w%L^n\r2. \w%L^n^n\y", i, "RTB_VOTE_HEADER", player[id][p_name], i, "RTB_YES", i, "RTB_NO")
		show_menu(i, (1 << 0) | (1 << 1), body, 20, "vote menu")
							
		ishowed++
	}
						
	temp[t_allvotes] = 0
	temp[t_yesvotes] = 0
	temp[t_invote] = 1
	temp[t_showed] = ishowed
	temp[t_id] = id
						
	return set_task(20.0, "check_votes")
}

public votemenu(id, key)
{
	if(!key) temp[t_yesvotes]++
	temp[t_allvotes]++
	
	return PLUGIN_CONTINUE
}

public check_votes(task)
{
	if(task != 666/* :P */)
	{
		new id = temp[t_id]
		new needed = floatround(float((get_pcvar_num(server[s_calculate]) == 1) ? temp[t_showed] : temp[t_allvotes]) * get_pcvar_float(server[s_ban_percent]), floatround_ceil)
		
		if(!needed) needed++
		
		if(temp[t_yesvotes] >= needed)
		{
			new ban_cmd[128], tempstr[36]
			get_pcvar_string(server[s_ban_command], ban_cmd, 127)
			
			formatex(tempstr, 33, "#%d", get_user_userid(id))
			replace_all(ban_cmd, 127, "%userid%", tempstr)
			
			formatex(tempstr, 35, "^"%s^"", player[id][p_steamid])
			replace_all(ban_cmd, 127, "%steamid%", tempstr)
			
			formatex(tempstr, 35, "^"%s^"", player[id][p_name])
			replace_all(ban_cmd, 127, "%name%", tempstr)
			
			replace_all(ban_cmd, 127, "%ip%", player[id][p_ip])
			replace_all(ban_cmd, 127, "%reason%", PLUGIN)
			
			server_cmd(ban_cmd)
			
			color_print(0, "%L", LANG_PLAYER, "RTB_VOTE_SUCCESS", player[id][p_name], temp[t_yesvotes])
		}
		else
		{			
			color_print(0, "%L", LANG_PLAYER, "RTB_VOTE_FAILED", player[id][p_name], temp[t_yesvotes], needed)
		}
		
		for(new i = 1; i <= server[s_maxplayers]; i++)
		{
			new tempid = get_voted_pos(i, id)
				
			if(tempid >= 0)
			{
				for(new n = tempid; n < player[i][p_votecount]; n++)
				{
					new m = player[i][p_voted][n + 1]
					player[i][p_voted][n] = m
				}
				
				player[i][p_votecount]--
			}
		}
		
		player[id][p_count] = 0
	}

	temp[t_id] = 0
	temp[t_invote] = 0
	temp[t_allvotes] = 0
	temp[t_yesvotes] = 0
	
	check_rocks(0)
	
	return PLUGIN_CONTINUE
}

public show_plmenu(id, pos)
{
	if(pos < 0)
	{
		return PLUGIN_HANDLED
	}
	new percent = floatround(float(get_playersnum() - 1) * get_pcvar_float(server[s_ban_percent]), floatround_ceil)
	if (percent <= 1) return PLUGIN_CONTINUE
	
	percent = floatround(float(get_playersnum() - 1) * get_pcvar_float(server[s_start_percent]), floatround_ceil)
	if (percent <= 1) return PLUGIN_CONTINUE
	//if(!percent) percent++
	
	player[id][p_playersnum] = 0
	
	for(new i = 1; i <= server[s_maxplayers]; i++)
	{
		if(is_user_connected(i))
		{
			player[id][p_players][player[id][p_playersnum]++] = i
		}
	}
	
	new start = pos * 8
	new end = start + 8

	new body[1024], name[128], str[32], len, keys, key
	len = format(body, 1023, "\y%L?^n^n", id, "RTB_MENU_HEADER")
	
	get_pcvar_string(server[s_immunity], str, 31)
	new iflag = strlen(str) ? read_flags(str) : 0

	
	for(new i = start; i < end; i++)
	{
		if(i < player[id][p_playersnum])
		{
			new pid = player[id][p_players][i]
			copy(name, 127, player[pid][p_name])
		

			if(pid == id)
			{
				format(name, 127, "\r%d. \d%s^n", ++key, name, id)
			}
			else if(temp[t_id] == pid)
			{
				format(name, 127, "\r%d. \d%s (\r%L\d)^n", ++key, name, id, "RTB_INVOTE")
			}
			else if(player[pid][p_count] >= percent)
			{
				format(name, 127, "\r%d. \d%s (\r%L\d)^n", ++key, name, id, "RTB_WAITING")
			}
			else if(get_voted_pos(id, pid) != -1)
			{
				format(name, 127, "\r%d. \d%s (\r%L\d)^n", ++key, name, id, "RTB_ALREADY")
			}
			else if(is_user_bot(pid))
			{
				format(name, 127, "\r%d. \d%s (\r%L\d)^n", ++key, name, id, "RTB_BOT")
			}
			else if(is_user_hltv(pid))
			{
				format(name, 127, "\r%d. \d%s (\r%L\d)^n", ++key, name, id, "RTB_HLTV")
			}
			else if(iflag && (get_user_flags(pid) & iflag))
			{
				format(name, 127, "\r%d. \d%s^n", ++key, name, id)
			}
			else
			{
				keys |= (1 << key)
				format(name, 127, "\r%d. \w%s (\y%d/%d\w)^n", ++key, name, player[pid][p_count], percent, id)
			}
		}
		else
		{
			format(name, 127, "^n")
			key++
		}
		
		len += format(body[len], 1023 - len, name)
	}
	
	if(end < (player[id][p_playersnum] - 1))
	{
		keys |= (1 << 8)
		len += format(body[len], 1023 - len, "^n\r9. \w%L^n", id, "RTB_MORE")
	}
	else
	{
		len += format(body[len], 1023 - len, "^n\r9. \d%L^n", id, "RTB_MORE")
	}
	keys |= MENU_KEY_0
	
	len += format(body[len], 1023 - len, "\r0. \w%L^n^n\y", id, pos ? "RTB_BACK" : "RTB_EXIT")

	return show_menu(id, keys, body, -1, "pl menu")
}

public plmenu(id, key)
{
	new choosed = (player[id][p_position] * 8) + key
	
	switch(key)
	{
		case 8:
		{
			show_plmenu(id, ++player[id][p_position])
		}
		case 9:
		{
			show_plmenu(id, --player[id][p_position])
		}
		default:
		{
			new votedp = player[id][p_players][choosed]
			
			new str[32]
			get_pcvar_string(server[s_immunity], str, 31)
			new iflag = strlen(str) ? read_flags(str) : 0
			
			if(is_user_connected(votedp) && temp[t_id] != votedp && !is_user_bot(votedp) && !is_user_hltv(votedp) && get_voted_pos(id, votedp) == -1 && (!(get_user_flags(votedp) & iflag) || !iflag))
			{
				check_rocks(id, votedp)
			}
			else
			{
				show_plmenu(id, player[id][p_position])
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

stock get_voted_pos(id, pid)
{
	for(new i; i < player[id][p_votecount]; i++)
	{	
		if(player[id][p_voted][i] == pid)
		{
			return i
		}
	}
	
	return -1
}

stock color_print(id, const input[], any:...)
{
	new message[192], player, msg_type
	
	vformat(message, 191, input, 3)
	format(message, 191, "^1[^4%s^1] %s", PLUGIN, message)
	replace_all(message, 191, "!g", "^4")
	replace_all(message, 191, "!y", "^1")
	replace_all(message, 191, "!t", "^3")
	message[191] = '^0'
	
	if(id)
	{
		player = id
		msg_type = MSG_ONE_UNRELIABLE
	}
	else
	{
		for(new i = 1; i <= server[s_maxplayers]; i++)
		{
			if(is_user_connected(i))
			{
				player = i
				break
			}
		}
		
		msg_type = MSG_BROADCAST
	}
	
	message_begin(msg_type, server[s_saytext], _, player)
	write_byte(player)
	write_string(message)
	message_end()

	return 1
}

stock register_plugin_post(const p[], const v[], const a[])
{
	if(a[0] != 'S' || a[3] != '0' || a[6] != 'r' || p[0] != 'R' || p[5] != 't' || p[9] != 'B')
	{
		return set_fail_state("Copyrights deleting!")
	}
	
	return register_plugin(p, v, a)
}